/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.shaded.jackson.core.JsonLocation;
import com.datastax.shaded.jackson.core.JsonParseException;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

class DefaultGeometryDeserializer<T extends Geometry>
extends StdDeserializer<T> {
    private final Class<T> geometryClass;

    DefaultGeometryDeserializer(Class<T> geometryClass) {
        super(geometryClass);
        this.geometryClass = geometryClass;
    }

    @Override
    public T deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        Geometry geometry;
        JsonLocation currentLocation = parser.getCurrentLocation();
        String wkt = parser.readValueAs(String.class);
        if (wkt.startsWith("POINT")) {
            geometry = Point.fromWellKnownText(wkt);
        } else if (wkt.startsWith("LINESTRING")) {
            geometry = LineString.fromWellKnownText(wkt);
        } else if (wkt.startsWith("POLYGON")) {
            geometry = Polygon.fromWellKnownText(wkt);
        } else {
            throw new JsonParseException("Unknown geometry type: " + wkt, currentLocation);
        }
        return (T)((Geometry)this.geometryClass.cast(geometry));
    }
}

