/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.DefaultProperty;
import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.PropertyGraphNodeParser;
import com.datastax.shaded.jackson.core.JsonParseException;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;

class DefaultPropertyDeserializer
extends StdDeserializer<DefaultProperty> {
    DefaultPropertyDeserializer() {
        super(DefaultProperty.class);
    }

    @Override
    public DefaultProperty deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        if (!(parser instanceof PropertyGraphNodeParser)) {
            throw new JsonParseException("Cannot deserialize property if parser is not instance of PropertyGraphNodeParser", parser.getCurrentLocation());
        }
        PropertyGraphNodeParser propertyParser = (PropertyGraphNodeParser)parser;
        String name = propertyParser.propertyName;
        if (name == null) {
            throw new JsonParseException("Cannot deserialize property without its name", parser.getCurrentLocation());
        }
        Element parent = propertyParser.parent;
        if (parent == null) {
            throw new JsonParseException("Cannot deserialize property with null parent", parser.getCurrentLocation());
        }
        JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
        DefaultProperty property = new DefaultProperty();
        property.name = name;
        property.value = new DefaultGraphNode(jacksonNode, (ObjectMapper)parser.getCodec());
        property.parent = parent;
        return property;
    }
}

