/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.Envelope2D;
import com.datastax.shaded.esri.GeoDist;
import com.datastax.shaded.esri.GeometryException;
import com.datastax.shaded.esri.PeDouble;
import com.datastax.shaded.esri.Point;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.Wkid;
import com.datastax.shaded.esri.Wkt;
import java.util.concurrent.locks.ReentrantLock;

class SpatialReferenceImpl
extends SpatialReference {
    static final boolean no_projection_engine = true;
    public static final int c_SULIMIT32 = 0x7FFFFFFD;
    public static final long c_SULIMIT64 = 0x1FFFFFFFFFFFFEL;
    int m_userWkid = 0;
    int m_userLatestWkid = -1;
    int m_userOldestWkid = -1;
    String m_userWkt = null;
    private static final ReentrantLock m_lock = new ReentrantLock();

    SpatialReferenceImpl() {
    }

    @Override
    public int getID() {
        return this.m_userWkid;
    }

    double getFalseX() {
        return 0.0;
    }

    double getFalseY() {
        return 0.0;
    }

    double getFalseZ() {
        return 0.0;
    }

    double getFalseM() {
        return 0.0;
    }

    double getGridUnitsXY() {
        return 5.7295779513082306E10;
    }

    double getGridUnitsZ() {
        return 1000.0;
    }

    double getGridUnitsM() {
        return 1000.0;
    }

    Precision getPrecision() {
        return Precision.Integer64;
    }

    @Override
    double getTolerance(int semantics) {
        double tolerance = 0.001;
        if (this.m_userWkid != 0) {
            tolerance = Wkid.find_tolerance_from_wkid(this.m_userWkid);
        } else if (this.m_userWkt != null) {
            tolerance = Wkt.find_tolerance_from_wkt(this.m_userWkt);
        }
        return tolerance;
    }

    public void queryValidCoordinateRange(Envelope2D env2D) {
        double delta = 0.0;
        switch (this.getPrecision()) {
            case Integer32: {
                delta = 2.147483645E9 / this.getGridUnitsXY();
                break;
            }
            case Integer64: {
                delta = 9.00719925474099E15 / this.getGridUnitsXY();
                break;
            }
            default: {
                throw GeometryException.GeometryInternalError();
            }
        }
        env2D.setCoords(this.getFalseX(), this.getFalseY(), this.getFalseX() + delta, this.getFalseY() + delta);
    }

    public boolean requiresReSimplify(SpatialReference dst) {
        return dst != this;
    }

    @Override
    public String getText() {
        return this.m_userWkt;
    }

    @Override
    int getOldID() {
        int ID_ = this.getID();
        if (this.m_userOldestWkid != -1) {
            return this.m_userOldestWkid;
        }
        this.m_userOldestWkid = Wkid.wkid_to_old(ID_);
        if (this.m_userOldestWkid != -1) {
            return this.m_userOldestWkid;
        }
        return ID_;
    }

    @Override
    int getLatestID() {
        int ID_ = this.getID();
        if (this.m_userLatestWkid != -1) {
            return this.m_userLatestWkid;
        }
        this.m_userLatestWkid = Wkid.wkid_to_new(ID_);
        if (this.m_userLatestWkid != -1) {
            return this.m_userLatestWkid;
        }
        return ID_;
    }

    public static SpatialReferenceImpl createImpl(int wkid) {
        if (wkid <= 0) {
            throw new IllegalArgumentException("Invalid or unsupported wkid: " + wkid);
        }
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        spatRef.m_userWkid = wkid;
        return spatRef;
    }

    public static SpatialReferenceImpl createImpl(String wkt) {
        if (wkt == null || wkt.length() == 0) {
            throw new IllegalArgumentException("Cannot create SpatialReference from null or empty text.");
        }
        SpatialReferenceImpl spatRef = new SpatialReferenceImpl();
        spatRef.m_userWkt = wkt;
        return spatRef;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpatialReferenceImpl sr = (SpatialReferenceImpl)obj;
        if (this.m_userWkid != sr.m_userWkid) {
            return false;
        }
        return this.m_userWkid != 0 || this.m_userWkt.equals(this.m_userWkt);
    }

    static double geodesicDistanceOnWGS84Impl(Point ptFrom, Point ptTo) {
        double a = 6378137.0;
        double e2 = 0.0066943799901413165;
        double rpu = Math.PI / 180;
        PeDouble answer = new PeDouble();
        GeoDist.geodesic_distance_ngs(a, e2, ptFrom.getXY().x * rpu, ptFrom.getXY().y * rpu, ptTo.getXY().x * rpu, ptTo.getXY().y * rpu, answer, null, null);
        return answer.val;
    }

    static enum Precision {
        Integer32,
        Integer64,
        FloatingPoint;

    }
}

