/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.Path;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class DefaultPath
implements Path {
    private static final Function<Set<String>, Set<String>> TO_UNMODIFIABLE_SET = new Function<Set<String>, Set<String>>(){

        public Set<String> apply(Set<String> input) {
            return Collections.unmodifiableSet(input);
        }
    };
    List<Set<String>> labels;
    List<GraphNode> objects;

    DefaultPath() {
    }

    @Override
    public List<Set<String>> getLabels() {
        return this.labels == null || this.labels.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(Lists.transform(this.labels, TO_UNMODIFIABLE_SET));
    }

    @Override
    public List<GraphNode> getObjects() {
        return this.objects == null || this.objects.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.objects);
    }

    @Override
    public int size() {
        return this.objects == null ? 0 : this.objects.size();
    }

    @Override
    public GraphNode getObject(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.getObjects().get(index);
    }

    @Override
    public GraphNode getObject(String label) {
        List<GraphNode> objects = this.getObjects(label);
        return objects.isEmpty() ? null : objects.get(0);
    }

    @Override
    public List<GraphNode> getObjects(String label) {
        ArrayList objects = Lists.newArrayListWithExpectedSize((int)1);
        List<Set<String>> labels = this.getLabels();
        for (int i = 0; i < labels.size(); ++i) {
            if (!labels.get(i).contains(label)) continue;
            objects.add(this.getObject(i));
        }
        return Collections.unmodifiableList(objects);
    }

    @Override
    public boolean hasLabel(String label) {
        for (Set<String> labelGroup : this.getLabels()) {
            if (!labelGroup.contains(label)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<GraphNode> iterator() {
        return this.getObjects().iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Path)) {
            return false;
        }
        Path that = (Path)o;
        return Objects.equal(this.getLabels(), that.getLabels()) && Objects.equal(this.getObjects(), that.getObjects());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getObjects()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("labels", this.getLabels()).add("objects", this.getObjects()).toString();
    }
}

