/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.jsontype.TypeSerializer;
import com.datastax.shaded.jackson.databind.module.SimpleModule;
import com.datastax.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

class DriverObjectsModule
extends SimpleModule {
    public DriverObjectsModule() {
        super("graph-graphson2driver");
        this.addSerializer(Element.class, new ElementGraphSON2Serializer());
        this.addSerializer(ObjectGraphNode.class, new ObjectGraphNodeGraphSON2Serializer());
    }

    static final class ObjectGraphNodeGraphSON2Serializer
    extends StdSerializer<ObjectGraphNode> {
        protected ObjectGraphNodeGraphSON2Serializer() {
            super(ObjectGraphNode.class);
        }

        @Override
        public void serialize(ObjectGraphNode objectGraphNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject(objectGraphNode.as(Object.class));
        }

        @Override
        public void serializeWithType(ObjectGraphNode objectGraphNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(objectGraphNode, jsonGenerator, serializerProvider);
        }
    }

    static final class ElementGraphSON2Serializer
    extends StdSerializer<Element> {
        protected ElementGraphSON2Serializer() {
            super(Element.class);
        }

        @Override
        public void serialize(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((ObjectGraphNode)element.getId());
        }

        @Override
        public void serializeWithType(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(element, jsonGenerator, serializerProvider);
        }
    }
}

