/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.GraphSONTypeDeserializer;
import com.datastax.driver.dse.graph.GraphSONTypeSerializer;
import com.datastax.driver.dse.graph.TypeInfo;
import com.datastax.shaded.jackson.databind.DeserializationConfig;
import com.datastax.shaded.jackson.databind.JavaType;
import com.datastax.shaded.jackson.databind.SerializationConfig;
import com.datastax.shaded.jackson.databind.jsontype.NamedType;
import com.datastax.shaded.jackson.databind.jsontype.TypeDeserializer;
import com.datastax.shaded.jackson.databind.jsontype.TypeIdResolver;
import com.datastax.shaded.jackson.databind.jsontype.TypeSerializer;
import com.datastax.shaded.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import java.util.Collection;

class GraphSONTypeResolverBuilder
extends StdTypeResolverBuilder {
    private TypeInfo typeInfo;
    private String valuePropertyName;

    GraphSONTypeResolverBuilder() {
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        TypeIdResolver idRes = this.idResolver(config, baseType, subtypes, false, true);
        return new GraphSONTypeDeserializer(baseType, idRes, this.getTypeProperty(), this.typeInfo, this.valuePropertyName);
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig config, JavaType baseType, Collection<NamedType> subtypes) {
        TypeIdResolver idRes = this.idResolver(config, baseType, subtypes, true, false);
        return new GraphSONTypeSerializer(idRes, this.getTypeProperty(), this.typeInfo, this.valuePropertyName);
    }

    public GraphSONTypeResolverBuilder valuePropertyName(String valuePropertyName) {
        this.valuePropertyName = valuePropertyName;
        return this;
    }

    public GraphSONTypeResolverBuilder typesEmbedding(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
        return this;
    }
}

