/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.IgnoreJDK6Requirement;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.Version;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonDeserializer;
import com.datastax.shaded.jackson.databind.JsonSerializer;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.module.SimpleModule;
import com.datastax.shaded.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

@IgnoreJDK6Requirement
class Jdk8Jsr310Module
extends SimpleModule {
    Jdk8Jsr310Module(String name, Version version) {
        super(name, version, Jdk8Jsr310Module.createDeserializers(), Jdk8Jsr310Module.createSerializers());
    }

    private static Map<Class<?>, JsonDeserializer<?>> createDeserializers() {
        return ImmutableMap.builder().put(Duration.class, (Object)new DurationJacksonDeserializer()).put(Instant.class, (Object)new InstantJacksonDeserializer()).put(ZonedDateTime.class, (Object)new ZonedDateTimeJacksonDeserializer()).build();
    }

    private static List<JsonSerializer<?>> createSerializers() {
        return ImmutableList.builder().add((Object)new DurationJacksonSerializer()).add((Object)new InstantJacksonSerializer()).add((Object)new ZonedDateTimeJacksonSerializer()).build();
    }

    @IgnoreJDK6Requirement
    static final class ZonedDateTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<ZonedDateTime> {
        public ZonedDateTimeJacksonDeserializer() {
            super(ZonedDateTime.class);
        }

        @Override
        public ZonedDateTime parse(String val) {
            return ZonedDateTime.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class ZonedDateTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<ZonedDateTime> {
        public ZonedDateTimeJacksonSerializer() {
            super(ZonedDateTime.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class InstantJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Instant> {
        public InstantJacksonDeserializer() {
            super(Instant.class);
        }

        @Override
        public Instant parse(String val) {
            return Instant.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class InstantJacksonSerializer
    extends AbstractJavaTimeSerializer<Instant> {
        public InstantJacksonSerializer() {
            super(Instant.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class DurationJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Duration> {
        public DurationJacksonDeserializer() {
            super(Duration.class);
        }

        @Override
        public Duration parse(String val) {
            return Duration.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class DurationJacksonSerializer
    extends AbstractJavaTimeSerializer<Duration> {
        public DurationJacksonSerializer() {
            super(Duration.class);
        }
    }

    @IgnoreJDK6Requirement
    static abstract class AbstractJavaTimeJacksonDeserializer<T>
    extends StdDeserializer<T> {
        public AbstractJavaTimeJacksonDeserializer(Class<T> clazz) {
            super(clazz);
        }

        public abstract T parse(String var1);

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.parse(jsonParser.getText());
        }
    }

    @IgnoreJDK6Requirement
    static abstract class AbstractJavaTimeSerializer<T>
    extends StdSerializer<T> {
        public AbstractJavaTimeSerializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

