/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.codehaus.jackson.JsonParseException;
import com.datastax.shaded.codehaus.jackson.JsonToken;
import com.datastax.shaded.esri.GeometryException;
import com.datastax.shaded.esri.JsonReader;
import com.datastax.shaded.esri.NumberUtils;
import java.io.IOException;

final class JSONUtils {
    JSONUtils() {
    }

    static boolean isObjectStart(JsonReader parser) throws Exception {
        return parser.currentToken() == null ? parser.nextToken() == JsonToken.START_OBJECT : parser.currentToken() == JsonToken.START_OBJECT;
    }

    static double readDouble(JsonReader parser) throws JsonParseException, IOException, Exception {
        if (parser.currentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            return parser.currentDoubleValue();
        }
        if (parser.currentToken() == JsonToken.VALUE_NUMBER_INT) {
            return parser.currentIntValue();
        }
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return NumberUtils.NaN();
        }
        if (parser.currentToken() == JsonToken.VALUE_STRING && parser.currentString().equals("NaN")) {
            return NumberUtils.NaN();
        }
        throw new GeometryException("invalid parameter");
    }
}

