/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.Boundary;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.Point;
import com.datastax.shaded.esri.ProgressTracker;

final class OperatorBoundaryLocalCursor
extends GeometryCursor {
    ProgressTracker m_progress_tracker;
    boolean m_b_done;
    GeometryCursor m_inputGeometryCursor;
    int m_index;

    OperatorBoundaryLocalCursor(GeometryCursor inputGeoms, ProgressTracker tracker) {
        this.m_inputGeometryCursor = inputGeoms;
        this.m_progress_tracker = tracker;
        this.m_b_done = false;
        this.m_index = -1;
    }

    @Override
    public Geometry next() {
        if (!this.m_b_done) {
            Geometry geometry = this.m_inputGeometryCursor.next();
            if (geometry != null) {
                this.m_index = this.m_inputGeometryCursor.getGeometryID();
                return OperatorBoundaryLocalCursor.calculate_boundary(geometry, this.m_progress_tracker);
            }
            this.m_b_done = true;
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    static Geometry calculate_boundary(Geometry geom, ProgressTracker progress_tracker) {
        Geometry res = Boundary.calculate(geom, progress_tracker);
        if (res == null) {
            return new Point(geom.getDescription());
        }
        return res;
    }
}

