/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.Clipper;
import com.datastax.shaded.esri.Envelope2D;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.InternalUtils;
import com.datastax.shaded.esri.ProgressTracker;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.SpatialReferenceImpl;

class OperatorClipCursor
extends GeometryCursor {
    GeometryCursor m_inputGeometryCursor;
    SpatialReferenceImpl m_spatialRefImpl;
    Envelope2D m_envelope;
    double m_tolerance;
    int m_index = -1;

    OperatorClipCursor(GeometryCursor geoms, Envelope2D envelope, SpatialReference spatial_ref, ProgressTracker progress_tracker) {
        if (geoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_envelope = envelope;
        this.m_inputGeometryCursor = geoms;
        this.m_spatialRefImpl = (SpatialReferenceImpl)spatial_ref;
        this.m_tolerance = InternalUtils.calculateToleranceFromGeometry(spatial_ref, envelope, false);
    }

    @Override
    public Geometry next() {
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_index = this.m_inputGeometryCursor.getGeometryID();
            return Clipper.clip(geometry, this.m_envelope, this.m_tolerance, 0.0);
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }
}

