/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri.ogc;

import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryEngine;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorExportToWkb;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.Polygon;
import com.datastax.shaded.esri.Polyline;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.ogc.OGCGeometry;
import com.datastax.shaded.esri.ogc.OGCLineString;
import com.datastax.shaded.esri.ogc.OGCLinearRing;
import com.datastax.shaded.esri.ogc.OGCMultiCurve;
import com.datastax.shaded.esri.ogc.OGCMultiPolygon;
import com.datastax.shaded.esri.ogc.OGCSurface;
import java.nio.ByteBuffer;

public class OGCPolygon
extends OGCSurface {
    Polygon polygon;

    public OGCPolygon(Polygon src, int exteriorRing, SpatialReference sr) {
        this.polygon = new Polygon();
        int n = src.getPathCount();
        for (int i = exteriorRing; !(i >= n || i > exteriorRing && src.isExteriorRing(i)); ++i) {
            this.polygon.addPath(src, i, true);
        }
        this.esriSR = sr;
    }

    public OGCPolygon(Polygon geom, SpatialReference sr) {
        this.polygon = geom;
        if (geom.getExteriorRingCount() > 1) {
            throw new IllegalArgumentException("Polygon has to have one exterior ring. Simplify geom with OperatorSimplify.");
        }
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 16);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(16, this.getEsriGeometry(), null);
    }

    public OGCLineString exteriorRing() {
        if (this.polygon.isEmpty()) {
            return new OGCLinearRing((Polygon)this.polygon.createInstance(), 0, this.esriSR, true);
        }
        return new OGCLinearRing(this.polygon, 0, this.esriSR, true);
    }

    public int numInteriorRing() {
        return this.polygon.getPathCount() - 1;
    }

    public OGCLineString interiorRingN(int n) {
        return new OGCLinearRing(this.polygon, n + 1, this.esriSR, true);
    }

    @Override
    public OGCMultiCurve boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCGeometry.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public String geometryType() {
        return "Polygon";
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return new OGCMultiPolygon(this.polygon, this.esriSR);
    }
}

