/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.graph.api;

import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.dse.graph.api.TraversalBatch;
import com.datastax.dse.graph.internal.DefaultTraversalBatch;
import com.datastax.dse.graph.internal.DseRemoteConnection;
import com.datastax.dse.graph.internal.utils.GraphSONUtils;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.util.empty.EmptyGraph;

public final class DseGraph {
    public static GraphTraversalSource traversal() {
        return EmptyGraph.instance().traversal();
    }

    public static <C extends GraphTraversalSource> C traversal(Class<C> traversalSourceClass) {
        return (C)((GraphTraversalSource)EmptyGraph.instance().traversal(traversalSourceClass));
    }

    public static GraphTraversalSource traversal(DseSession dseSession, GraphOptions graphOptions) {
        return DseGraph.traversal().withRemote((RemoteConnection)DseRemoteConnection.builder(dseSession).withGraphOptions(graphOptions).build());
    }

    public static <C extends GraphTraversalSource> C traversal(DseSession dseSession, GraphOptions graphOptions, Class<C> traversalSourceClass) {
        return (C)DseGraph.traversal(traversalSourceClass).withRemote((RemoteConnection)DseRemoteConnection.builder(dseSession).withGraphOptions(graphOptions).build());
    }

    public static GraphTraversalSource traversal(DseSession dseSession) {
        return DseGraph.traversal().withRemote((RemoteConnection)DseRemoteConnection.builder(dseSession).build());
    }

    public static <C extends GraphTraversalSource> C traversal(DseSession dseSession, Class<C> traversalSourceClass) {
        return (C)DseGraph.traversal(traversalSourceClass).withRemote((RemoteConnection)DseRemoteConnection.builder(dseSession).build());
    }

    public static <S, E> GraphStatement statementFromTraversal(GraphTraversal<S, E> traversal) {
        return GraphSONUtils.getStatementFromBytecode(traversal.asAdmin().getBytecode()).setTransformResultFunction(GraphJsonUtils.ROW_TO_GRAPHSON2_OBJECTGRAPHNODE);
    }

    public static TraversalBatch batch() {
        return new DefaultTraversalBatch();
    }
}

