/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.graph.internal;

import com.datastax.driver.dse.geometry.Distance;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.dse.graph.internal.DsePredicate;
import com.google.common.base.Preconditions;

public enum GeoPredicate implements DsePredicate
{
    inside{

        @Override
        public boolean test(Object value, Object condition) {
            this.preEvaluate(condition);
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geometry));
            Distance distance = (Distance)condition;
            if (value instanceof Point) {
                return 1.haversineDistanceInDegrees(distance.getCenter(), (Point)value) <= distance.getRadius();
            }
            if (value instanceof Polygon) {
                for (Point point : ((Polygon)value).getExteriorRing()) {
                    if (!(1.haversineDistanceInDegrees(distance.getCenter(), point) > distance.getRadius())) continue;
                    return false;
                }
            } else if (value instanceof LineString) {
                for (Point point : ((LineString)value).getPoints()) {
                    if (!(1.haversineDistanceInDegrees(distance.getCenter(), point) > distance.getRadius())) continue;
                    return false;
                }
            } else {
                throw new UnsupportedOperationException(String.format("Value type '%s' unsupported", value.getClass().getName()));
            }
            return true;
        }

        public String toString() {
            return "inside";
        }
    }
    ,
    insideCartesian{

        @Override
        public boolean test(Object value, Object condition) {
            this.preEvaluate(condition);
            if (value == null) {
                return false;
            }
            Preconditions.checkArgument((boolean)(value instanceof Geometry));
            return ((Geometry)condition).contains((Geometry)value);
        }

        public String toString() {
            return "insideCartesian";
        }
    };


    @Override
    public boolean isValidCondition(Object condition) {
        return condition != null;
    }

    static double haversineDistanceInDegrees(Point p1, Point p2) {
        double dLat = Math.toRadians(p2.Y() - p1.Y());
        double dLon = Math.toRadians(p2.X() - p1.X());
        double lat1 = Math.toRadians(p1.Y());
        double lat2 = Math.toRadians(p2.Y());
        double a = Math.pow(Math.sin(dLat / 2.0), 2.0) + Math.pow(Math.sin(dLon / 2.0), 2.0) * Math.cos(lat1) * Math.cos(lat2);
        double c = 2.0 * Math.asin(Math.sqrt(a));
        return Math.toDegrees(c);
    }
}

