/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.graph.internal.serde;

import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import java.io.IOException;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;

public class DriverObjectsModule
extends SimpleModule {
    public DriverObjectsModule() {
        super("datastax-driver-module");
        this.addSerializer(Element.class, (JsonSerializer)new ElementGraphSON2Serializer());
        this.addSerializer(ObjectGraphNode.class, (JsonSerializer)new ObjectGraphNodeGraphSON2Serializer());
    }

    static final class ObjectGraphNodeGraphSON2Serializer
    extends StdSerializer<ObjectGraphNode> {
        protected ObjectGraphNodeGraphSON2Serializer() {
            super(ObjectGraphNode.class);
        }

        public void serialize(ObjectGraphNode objectGraphNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject(objectGraphNode.as(Object.class));
        }

        public void serializeWithType(ObjectGraphNode objectGraphNode, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(objectGraphNode, jsonGenerator, serializerProvider);
        }
    }

    static final class ElementGraphSON2Serializer
    extends StdSerializer<Element> {
        protected ElementGraphSON2Serializer() {
            super(Element.class);
        }

        public void serialize(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeObject((Object)element.getId());
        }

        public void serializeWithType(Element element, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
            this.serialize(element, jsonGenerator, serializerProvider);
        }
    }
}

