/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.graph.internal;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.graph.GraphProtocol;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.dse.graph.internal.utils.GraphSONUtils;

public class RemoteSourceSimpleGraphStatement
extends GraphStatement {
    private final String query;
    private ConsistencyLevel nativeConsistencyLevel;
    private long defaultTimestamp = Long.MIN_VALUE;
    private volatile int readTimeoutMillis = Integer.MIN_VALUE;
    private String authorizationId;

    public RemoteSourceSimpleGraphStatement(String query) {
        this.query = query;
    }

    public GraphStatement setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.nativeConsistencyLevel = consistencyLevel;
        return this;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.nativeConsistencyLevel;
    }

    public GraphStatement setDefaultTimestamp(long defaultTimestamp) {
        this.defaultTimestamp = defaultTimestamp;
        return this;
    }

    public long getDefaultTimestamp() {
        return this.defaultTimestamp;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public GraphStatement setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public GraphStatement executingAs(String userOrRole) {
        this.authorizationId = userOrRole;
        return this;
    }

    @Deprecated
    public Statement unwrap() {
        return this.unwrap(GraphProtocol.GRAPHSON_2_0);
    }

    @Deprecated
    public Statement unwrap(GraphProtocol graphProtocol) {
        return this.unwrap(new GraphOptions().setGraphSubProtocol(graphProtocol));
    }

    public Statement unwrap(GraphOptions graphOptions) {
        SimpleStatement statement = new SimpleStatement(this.query);
        if (this.getConsistencyLevel() != null) {
            statement.setConsistencyLevel(this.nativeConsistencyLevel);
        }
        if (this.getDefaultTimestamp() != Long.MIN_VALUE) {
            statement.setDefaultTimestamp(this.defaultTimestamp);
        }
        if (this.getReadTimeoutMillis() != Integer.MIN_VALUE) {
            statement.setReadTimeoutMillis(this.readTimeoutMillis);
        }
        if (this.authorizationId != null) {
            statement.executingAs(this.authorizationId);
        }
        this.setGraphLanguage("bytecode-json");
        this.setTransformResultFunction(GraphSONUtils.ROW_TO_GRAPHSON2_TINKERPOP_OBJECTGRAPHNODE);
        return statement;
    }
}

