/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.dse.graph.internal;

import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.dse.graph.api.TraversalBatch;
import com.datastax.dse.graph.internal.utils.GraphSONUtils;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

public class DefaultTraversalBatch extends TraversalBatch {

  private final Queue<GraphTraversal> traversals = new ConcurrentLinkedQueue<>();

  @Override
  public void add(GraphTraversal graphTraversal) {
    this.traversals.add(graphTraversal);
  }

  @Override
  public void addAll(Iterable<GraphTraversal> newTraversals) {
    List<GraphTraversal> copyList = ImmutableList.copyOf(newTraversals);
    this.traversals.addAll(copyList);
  }

  @Override
  public int size() {
    return this.traversals.size();
  }

  @Override
  public GraphStatement asGraphStatement() {
    return GraphSONUtils.getStatementFromBytecodes(this.traversals)
        .setTransformResultFunction(GraphJsonUtils.ROW_TO_GRAPHSON2_OBJECTGRAPHNODE);
  }

  @Override
  public Iterator<GraphTraversal> iterator() {
    return this.traversals.iterator();
  }
}
