/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.graph.internal.utils;

import com.datastax.driver.core.Row;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.datastax.dse.graph.internal.RemoteSourceSimpleGraphStatement;
import com.datastax.dse.graph.internal.serde.DriverObjectsModule;
import com.datastax.dse.graph.internal.serde.DseGraphModule;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.tinkerpop.gremlin.process.traversal.Bytecode;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONWriter;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONXModuleV2d0;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV2d0;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;

public class GraphSONUtils {
    public static final String BYTECODE_GRAPHSON_GRAPH_LANGUAGE = "bytecode-json";
    private static final GraphSONMapper GRAPHSON_MAPPER_2_0 = GraphSONMapper.build().version(GraphSONVersion.V2_0).typeInfo(TypeInfo.PARTIAL_TYPES).addRegistry((IoRegistry)TinkerIoRegistryV2d0.instance()).addCustomModule((SimpleModule)GraphSONXModuleV2d0.build().create(false)).addCustomModule((SimpleModule)new DseGraphModule()).addCustomModule((SimpleModule)new DriverObjectsModule()).create();
    private static final GraphWriter GRAPHSON_WRITER_2_0 = GraphSONWriter.build().mapper((Mapper)GRAPHSON_MAPPER_2_0).create();
    private static final GraphReader GRAPHSON_READER_2_0 = GraphSONReader.build().mapper((Mapper)GRAPHSON_MAPPER_2_0).create();
    public static final Function<Row, GraphNode> ROW_TO_GRAPHSON2_TINKERPOP_OBJECTGRAPHNODE = input -> {
        if (input == null) {
            return null;
        }
        Object deserializedObject = null;
        if (input.getColumnDefinitions().contains("gremlin")) {
            try {
                deserializedObject = GraphSONUtils.readStringAs(input.getString("gremlin"), Object.class);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return new ObjectGraphNode(deserializedObject);
    };

    public static <V> V readStringAs(String json, Class<V> destClass) throws IOException {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(json.getBytes("UTF-8"));){
            Object object = GRAPHSON_READER_2_0.readObject((InputStream)bais, destClass);
            return (V)object;
        }
    }

    public static String writeValueAsString(Object valueToWrite) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            GRAPHSON_WRITER_2_0.writeObject((OutputStream)out, valueToWrite);
            String string = out.toString("UTF-8");
            return string;
        }
    }

    public static GraphStatement getStatementFromBytecodes(Collection<GraphTraversal> traversals) {
        try {
            String serializedBytecode = GraphSONUtils.writeValueAsString(traversals);
            SimpleGraphStatement simpleGraphStatement = new SimpleGraphStatement(serializedBytecode);
            simpleGraphStatement.setGraphLanguage(BYTECODE_GRAPHSON_GRAPH_LANGUAGE);
            return simpleGraphStatement;
        }
        catch (IOException e) {
            throw new DriverException("Could not serialize traversals.", (Throwable)e);
        }
    }

    public static GraphStatement getStatementFromBytecode(Bytecode bytecode) {
        try {
            String serializedBytecode = GraphSONUtils.writeValueAsString(bytecode);
            SimpleGraphStatement simpleGraphStatement = new SimpleGraphStatement(serializedBytecode);
            simpleGraphStatement.setGraphLanguage(BYTECODE_GRAPHSON_GRAPH_LANGUAGE);
            return simpleGraphStatement;
        }
        catch (IOException e) {
            throw new DriverException("Could not serialize Traversal's bytecode.", (Throwable)e);
        }
    }

    public static GraphStatement getStatementFromBytecodeRemoteSource(Bytecode bytecode) {
        try {
            String serializedBytecode = GraphSONUtils.writeValueAsString(bytecode);
            return new RemoteSourceSimpleGraphStatement(serializedBytecode);
        }
        catch (IOException e) {
            throw new DriverException("Could not serialize Traversal's bytecode.", (Throwable)e);
        }
    }
}

