/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;

public abstract class ConvertingCodec<EXTERNAL, INTERNAL>
implements TypeCodec<EXTERNAL> {
    protected final TypeCodec<INTERNAL> internalCodec;
    protected final GenericType<EXTERNAL> javaType;

    protected ConvertingCodec(TypeCodec<INTERNAL> internalCodec, Class<EXTERNAL> javaType) {
        this.internalCodec = internalCodec;
        this.javaType = GenericType.of(javaType);
    }

    protected ConvertingCodec(TypeCodec<INTERNAL> internalCodec, GenericType<EXTERNAL> javaType) {
        this.internalCodec = internalCodec;
        this.javaType = javaType;
    }

    @NonNull
    public DataType getCqlType() {
        return this.internalCodec.getCqlType();
    }

    @NonNull
    public GenericType<EXTERNAL> getJavaType() {
        return this.javaType;
    }

    public TypeCodec<INTERNAL> getInternalCodec() {
        return this.internalCodec;
    }

    public GenericType<INTERNAL> getInternalJavaType() {
        return this.internalCodec.getJavaType();
    }

    public ByteBuffer encode(EXTERNAL external, @NonNull ProtocolVersion protocolVersion) {
        INTERNAL value = this.externalToInternal(external);
        return this.internalCodec.encode(value, protocolVersion);
    }

    public EXTERNAL decode(ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        Object internal = this.internalCodec.decode(bytes, protocolVersion);
        return this.internalToExternal(internal);
    }

    public EXTERNAL parse(String s) {
        Object value = this.internalCodec.parse(s);
        return this.internalToExternal(value);
    }

    @NonNull
    public String format(EXTERNAL s) {
        INTERNAL value = this.externalToInternal(s);
        return this.internalCodec.format(value);
    }

    public abstract INTERNAL externalToInternal(EXTERNAL var1);

    public abstract EXTERNAL internalToExternal(INTERNAL var1);
}

