/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.api.util;

import com.datastax.oss.driver.internal.core.os.Native;
import com.datastax.oss.driver.shaded.guava.common.base.Charsets;
import com.datastax.oss.driver.shaded.guava.common.base.Splitter;
import com.datastax.oss.driver.shaded.guava.common.collect.Iterables;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public enum TimeUUIDGenerator {
    FIXED{

        @Override
        public UUID generate(Instant instant) {
            return new UUID(TimeUUIDGenerator.createMostSignificantBits(1.toUUIDTimestamp(instant)), FIXED_CLOCK_SEQ_AND_NODE);
        }
    }
    ,
    RANDOM{

        @Override
        public UUID generate(Instant instant) {
            return new UUID(TimeUUIDGenerator.createMostSignificantBits(2.toUUIDTimestamp(instant)), RANDOM_CLOCK_SEQ_AND_NODE.nextLong());
        }
    }
    ,
    MIN{

        @Override
        public UUID generate(Instant instant) {
            return new UUID(TimeUUIDGenerator.createMostSignificantBits(3.toUUIDTimestamp(instant)), -9187201950435737472L);
        }
    }
    ,
    MAX{

        @Override
        public UUID generate(Instant instant) {
            return new UUID(TimeUUIDGenerator.createMostSignificantBits(4.toUUIDTimestamp(instant)), 0x7F7F7F7F7F7F7F7FL);
        }
    };

    public static final long EPOCH_OFFSET = 122192928000000000L;
    private static final long FIXED_CLOCK_SEQ_AND_NODE;
    private static final long MIN_CLOCK_SEQ_AND_NODE = -9187201950435737472L;
    private static final long MAX_CLOCK_SEQ_AND_NODE = 0x7F7F7F7F7F7F7F7FL;
    private static final Random RANDOM_CLOCK_SEQ_AND_NODE;

    public abstract UUID generate(Instant var1);

    public static long toUUIDTimestamp(Instant instant) {
        return (TimeUnit.SECONDS.toNanos(instant.getEpochSecond()) + (long)instant.getNano()) / 100L + 122192928000000000L;
    }

    public static Instant fromUUIDTimestamp(long timestamp) {
        long n = timestamp - 122192928000000000L;
        long seconds = n / 10000000L;
        long nanos = n - seconds * 10000000L;
        return Instant.ofEpochSecond(seconds, nanos * 100L);
    }

    private static long makeClockSeqAndNode() {
        long clock = new SecureRandom().nextLong();
        long lsb = 0L;
        lsb |= Long.MIN_VALUE;
        lsb |= (clock & 0x3FFFL) << 48;
        return lsb |= TimeUUIDGenerator.makeNode();
    }

    private static long createMostSignificantBits(long nanosSince) {
        long msb = 0L;
        msb |= (0xFFFFFFFFL & nanosSince) << 32;
        msb |= (0xFFFF00000000L & nanosSince) >>> 16;
        msb |= (0xFFFF000000000000L & nanosSince) >>> 48;
        return msb |= 0x1000L;
    }

    private static long makeNode() {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            for (String address : TimeUUIDGenerator.getAllLocalAddresses()) {
                TimeUUIDGenerator.update(digest, address);
            }
            Properties props = System.getProperties();
            TimeUUIDGenerator.update(digest, props.getProperty("java.vendor"));
            TimeUUIDGenerator.update(digest, props.getProperty("java.vendor.url"));
            TimeUUIDGenerator.update(digest, props.getProperty("java.version"));
            TimeUUIDGenerator.update(digest, props.getProperty("os.arch"));
            TimeUUIDGenerator.update(digest, props.getProperty("os.name"));
            TimeUUIDGenerator.update(digest, props.getProperty("os.version"));
            TimeUUIDGenerator.update(digest, Integer.toString(TimeUUIDGenerator.pid()));
            byte[] hash = digest.digest();
            long node = 0L;
            for (int i = 0; i < 6; ++i) {
                node |= (0xFFL & (long)hash[i]) << i * 8;
            }
            return node | 0x10000000000L;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static void update(MessageDigest digest, String value) {
        if (value != null) {
            digest.update(value.getBytes(Charsets.UTF_8));
        }
    }

    private static Set<String> getAllLocalAddresses() {
        HashSet<String> allIps = new HashSet<String>();
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            allIps.add(localhost.toString());
            allIps.add(localhost.getCanonicalHostName());
            InetAddress[] allMyIps = InetAddress.getAllByName(localhost.getCanonicalHostName());
            if (allMyIps != null) {
                for (InetAddress ip : allMyIps) {
                    allIps.add(ip.toString());
                }
            }
        }
        catch (UnknownHostException localhost) {
            // empty catch block
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            if (en != null) {
                while (en.hasMoreElements()) {
                    Enumeration<InetAddress> enumIpAddr = en.nextElement().getInetAddresses();
                    while (enumIpAddr.hasMoreElements()) {
                        allIps.add(enumIpAddr.nextElement().toString());
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return allIps;
    }

    private static int pid() {
        if (Native.isGetProcessIdAvailable()) {
            return Native.getProcessId();
        }
        try {
            String pidJmx = (String)Iterables.get((Iterable)Splitter.on((char)'@').split((CharSequence)ManagementFactory.getRuntimeMXBean().getName()), (int)0);
            return Integer.parseInt(pidJmx);
        }
        catch (Exception ignored) {
            return new Random(System.currentTimeMillis()).nextInt();
        }
    }

    static {
        FIXED_CLOCK_SEQ_AND_NODE = TimeUUIDGenerator.makeClockSeqAndNode();
        RANDOM_CLOCK_SEQ_AND_NODE = new Random(System.currentTimeMillis());
    }
}

