/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.SetType;
import edu.umd.cs.findbugs.annotations.NonNull;

public class JdkCodecUtils {
    public static boolean isNumeric(@NonNull DataType cqlType) {
        return cqlType == DataTypes.TINYINT || cqlType == DataTypes.SMALLINT || cqlType == DataTypes.INT || cqlType == DataTypes.BIGINT || cqlType == DataTypes.FLOAT || cqlType == DataTypes.DOUBLE || cqlType == DataTypes.VARINT || cqlType == DataTypes.DECIMAL;
    }

    public static boolean isCollection(@NonNull DataType cqlType) {
        return cqlType instanceof SetType || cqlType instanceof ListType;
    }

    public static boolean isTemporal(@NonNull DataType cqlType) {
        return cqlType == DataTypes.DATE || cqlType == DataTypes.TIME || cqlType == DataTypes.TIMESTAMP;
    }

    public static boolean isUUID(@NonNull DataType cqlType) {
        return cqlType == DataTypes.UUID || cqlType == DataTypes.TIMEUUID;
    }
}

