/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.bool;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.api.IdempotentConvertingCodec;
import com.datastax.oss.dsbulk.codecs.jdk.JdkCodecUtils;
import com.datastax.oss.dsbulk.codecs.jdk.bool.BooleanToNumberCodec;
import com.datastax.oss.dsbulk.codecs.jdk.bool.BooleanToStringCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Optional;

public class BooleanConvertingCodecsProvider
implements ConvertingCodecProvider {
    @NonNull
    public Optional<ConvertingCodec<?, ?>> maybeProvide(@NonNull DataType cqlType, @NonNull GenericType<?> externalJavaType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        if (externalJavaType.equals((Object)GenericType.BOOLEAN)) {
            if (cqlType == DataTypes.TEXT) {
                return Optional.of(new BooleanToStringCodec());
            }
            if (cqlType == DataTypes.BOOLEAN) {
                return Optional.of(new IdempotentConvertingCodec((TypeCodec)TypeCodecs.BOOLEAN));
            }
            if (JdkCodecUtils.isNumeric(cqlType)) {
                TypeCodec typeCodec = codecFactory.getCodecRegistry().codecFor(cqlType);
                return Optional.of(new BooleanToNumberCodec(typeCodec, (List)codecFactory.getContext().getAttribute("BOOLEAN_NUMBERS")));
            }
        }
        return Optional.empty();
    }
}

