/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.bool;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

public class BooleanToNumberCodec<INTERNAL extends Number>
extends ConvertingCodec<Boolean, INTERNAL> {
    private final List<INTERNAL> booleanNumbers;

    public BooleanToNumberCodec(TypeCodec<INTERNAL> targetCodec, List<BigDecimal> booleanNumbers) {
        super(targetCodec, Boolean.class);
        this.booleanNumbers = booleanNumbers.stream().map(n -> CodecUtils.convertNumber((Number)n, (Class)targetCodec.getJavaType().getRawType())).collect(Collectors.toList());
    }

    public INTERNAL externalToInternal(Boolean value) {
        if (value == null) {
            return null;
        }
        return (INTERNAL)((Number)this.booleanNumbers.get(value != false ? 0 : 1));
    }

    public Boolean internalToExternal(INTERNAL value) {
        if (value == null) {
            return null;
        }
        int i = this.booleanNumbers.indexOf(value);
        if (i == -1) {
            throw new IllegalArgumentException(String.format("Invalid boolean number %s, accepted values are %s (true) and %s (false)", value, this.booleanNumbers.get(0), this.booleanNumbers.get(1)));
        }
        return i == 0;
    }
}

