/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.collection;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.jdk.JdkCodecUtils;
import com.datastax.oss.dsbulk.codecs.jdk.collection.CollectionToCollectionCodec;
import com.datastax.oss.dsbulk.codecs.jdk.collection.ListToTupleCodec;
import com.datastax.oss.dsbulk.codecs.jdk.collection.ListToUDTCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

public class CollectionConvertingCodecsProvider
implements ConvertingCodecProvider {
    @NonNull
    public Optional<ConvertingCodec<?, ?>> maybeProvide(@NonNull DataType cqlType, @NonNull GenericType<?> externalJavaType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        GenericType componentType;
        MutableCodecRegistry codecRegistry = codecFactory.getCodecRegistry();
        if (externalJavaType.isSubtypeOf(GenericType.of(List.class)) && externalJavaType.getType() instanceof ParameterizedType && ((ParameterizedType)externalJavaType.getType()).getActualTypeArguments().length == 1) {
            componentType = GenericType.of((Type)((ParameterizedType)externalJavaType.getType()).getActualTypeArguments()[0]);
            if (cqlType instanceof UserDefinedType) {
                TypeCodec udtCodec = codecRegistry.codecFor(cqlType);
                ImmutableList.Builder eltCodecs = new ImmutableList.Builder();
                for (DataType eltType : ((UserDefinedType)cqlType).getFieldTypes()) {
                    ConvertingCodec eltCodec = codecFactory.createConvertingCodec(eltType, componentType, false);
                    eltCodecs.add((Object)eltCodec);
                }
                ListToUDTCodec codec = new ListToUDTCodec(externalJavaType.getRawType(), (TypeCodec<UdtValue>)udtCodec, eltCodecs.build());
                return Optional.of(codec);
            }
            if (cqlType instanceof TupleType) {
                TypeCodec tupleCodec = codecRegistry.codecFor(cqlType);
                ImmutableList.Builder eltCodecs = new ImmutableList.Builder();
                for (DataType eltType : ((TupleType)cqlType).getComponentTypes()) {
                    ConvertingCodec eltCodec = codecFactory.createConvertingCodec(eltType, componentType, false);
                    eltCodecs.add((Object)eltCodec);
                }
                Object codec = new ListToTupleCodec(externalJavaType.getRawType(), (TypeCodec<TupleValue>)tupleCodec, eltCodecs.build());
                return Optional.of(codec);
            }
        }
        if (externalJavaType.isSubtypeOf(GenericType.of(Collection.class)) && externalJavaType.getType() instanceof ParameterizedType && ((ParameterizedType)externalJavaType.getType()).getActualTypeArguments().length == 1) {
            componentType = GenericType.of((Type)((ParameterizedType)externalJavaType.getType()).getActualTypeArguments()[0]);
            if (JdkCodecUtils.isCollection(cqlType)) {
                TypeCodec typeCodec = codecRegistry.codecFor(cqlType);
                ConvertingCodec elementCodec = null;
                if (cqlType instanceof SetType) {
                    elementCodec = codecFactory.createConvertingCodec(((SetType)cqlType).getElementType(), componentType, false);
                } else if (cqlType instanceof ListType) {
                    elementCodec = codecFactory.createConvertingCodec(((ListType)cqlType).getElementType(), componentType, false);
                }
                Supplier<Collection> collectionCreator = cqlType instanceof SetType ? HashSet::new : ArrayList::new;
                Class collType = externalJavaType.getRawType();
                CollectionToCollectionCodec codec = new CollectionToCollectionCodec(collType, typeCodec, (ConvertingCodec<Object, Object>)elementCodec, collectionCreator);
                return Optional.of(codec);
            }
        }
        return Optional.empty();
    }
}

