/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.collection;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import java.util.Collection;
import java.util.function.Supplier;

public class CollectionToCollectionCodec<EXTERNAL extends Collection<Object>, INTERNAL extends Collection<Object>>
extends ConvertingCodec<EXTERNAL, INTERNAL> {
    private final ConvertingCodec<Object, Object> elementCodec;
    private final Supplier<INTERNAL> collectionCreator;

    public CollectionToCollectionCodec(Class<EXTERNAL> javaType, TypeCodec<INTERNAL> targetCodec, ConvertingCodec<Object, Object> elementCodec, Supplier<INTERNAL> collectionCreator) {
        super(targetCodec, javaType);
        this.elementCodec = elementCodec;
        this.collectionCreator = collectionCreator;
    }

    public INTERNAL externalToInternal(EXTERNAL external) {
        if (external == null || external.isEmpty()) {
            return null;
        }
        Collection result = (Collection)this.collectionCreator.get();
        for (Object item : external) {
            result.add(this.elementCodec.externalToInternal(item));
        }
        return (INTERNAL)result;
    }

    public EXTERNAL internalToExternal(INTERNAL internal) {
        if (internal == null) {
            return null;
        }
        throw new UnsupportedOperationException("This codec does not support converting from the 'internal' collection to the 'external'");
    }
}

