/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.collection;

import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import java.util.ArrayList;
import java.util.List;

public class ListToTupleCodec<E>
extends ConvertingCodec<List<E>, TupleValue> {
    private final List<ConvertingCodec<E, Object>> elementCodecs;
    private final TupleType definition;

    public ListToTupleCodec(Class<List<E>> javaType, TypeCodec<TupleValue> targetCodec, List<ConvertingCodec<E, Object>> elementCodecs) {
        super(targetCodec, javaType);
        this.elementCodecs = elementCodecs;
        this.definition = (TupleType)targetCodec.getCqlType();
    }

    public TupleValue externalToInternal(List<E> external) {
        if (external == null || external.isEmpty()) {
            return null;
        }
        int size = this.definition.getComponentTypes().size();
        if (external.size() != size) {
            throw new IllegalArgumentException(String.format("Expecting %d elements, got %d", size, external.size()));
        }
        TupleValue tuple = this.definition.newValue();
        int idx = 0;
        for (E item : external) {
            ConvertingCodec<E, Object> eltCodec = this.elementCodecs.get(idx);
            Object o = eltCodec.externalToInternal(item);
            tuple = (TupleValue)tuple.set(idx, o, eltCodec.getInternalJavaType());
            ++idx;
        }
        return tuple;
    }

    public List<E> internalToExternal(TupleValue tuple) {
        if (tuple == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int size = this.definition.getComponentTypes().size();
        for (int i = 0; i < size; ++i) {
            ConvertingCodec<E, Object> eltCodec = this.elementCodecs.get(i);
            Object o = tuple.get(i, eltCodec.getInternalJavaType());
            result.add(eltCodec.internalToExternal(o));
        }
        return result;
    }
}

