/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.collection;

import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import java.util.ArrayList;
import java.util.List;

public class ListToUDTCodec<E>
extends ConvertingCodec<List<E>, UdtValue> {
    private final List<ConvertingCodec<E, Object>> elementCodecs;
    private final UserDefinedType definition;

    public ListToUDTCodec(Class<List<E>> javaType, TypeCodec<UdtValue> targetCodec, List<ConvertingCodec<E, Object>> elementCodecs) {
        super(targetCodec, javaType);
        this.elementCodecs = elementCodecs;
        this.definition = (UserDefinedType)targetCodec.getCqlType();
    }

    public UdtValue externalToInternal(List<E> external) {
        if (external == null || external.isEmpty()) {
            return null;
        }
        int size = this.definition.getFieldNames().size();
        if (external.size() != size) {
            throw new IllegalArgumentException(String.format("Expecting %d elements, got %d", size, external.size()));
        }
        UdtValue value = this.definition.newValue();
        int idx = 0;
        for (E item : external) {
            ConvertingCodec<E, Object> eltCodec = this.elementCodecs.get(idx);
            Object o = eltCodec.externalToInternal(item);
            value = (UdtValue)value.set(idx, o, eltCodec.getInternalJavaType());
            ++idx;
        }
        return value;
    }

    public List<E> internalToExternal(UdtValue tuple) {
        if (tuple == null) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        int size = this.definition.getFieldNames().size();
        for (int i = 0; i < size; ++i) {
            ConvertingCodec<E, Object> eltCodec = this.elementCodecs.get(i);
            Object o = tuple.get(i, eltCodec.getInternalJavaType());
            result.add(eltCodec.internalToExternal(o));
        }
        return result;
    }
}

