/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.map;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.jdk.map.MapToMapCodec;
import com.datastax.oss.dsbulk.codecs.jdk.map.MapToUDTCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class MapConvertingCodecsProvider
implements ConvertingCodecProvider {
    @NonNull
    public Optional<ConvertingCodec<?, ?>> maybeProvide(@NonNull DataType cqlType, @NonNull GenericType<?> externalJavaType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        MutableCodecRegistry codecRegistry = codecFactory.getCodecRegistry();
        if (externalJavaType.isSubtypeOf(GenericType.of(Map.class)) && externalJavaType.getType() instanceof ParameterizedType && ((ParameterizedType)externalJavaType.getType()).getActualTypeArguments().length == 2) {
            GenericType keyType = GenericType.of((Type)((ParameterizedType)externalJavaType.getType()).getActualTypeArguments()[0]);
            GenericType valueType = GenericType.of((Type)((ParameterizedType)externalJavaType.getType()).getActualTypeArguments()[1]);
            if (cqlType instanceof MapType) {
                TypeCodec typeCodec = codecRegistry.codecFor(cqlType);
                ConvertingCodec keyConvertingCodec = codecFactory.createConvertingCodec(((MapType)cqlType).getKeyType(), keyType, false);
                ConvertingCodec valueConvertingCodec = codecFactory.createConvertingCodec(((MapType)cqlType).getValueType(), valueType, false);
                MapToMapCodec codec = new MapToMapCodec(externalJavaType.getRawType(), typeCodec, keyConvertingCodec, valueConvertingCodec);
                return Optional.of(codec);
            }
            if (cqlType instanceof UserDefinedType) {
                TypeCodec udtCodec = codecRegistry.codecFor(cqlType);
                ImmutableMap.Builder fieldCodecs = new ImmutableMap.Builder();
                List fieldNames = ((UserDefinedType)cqlType).getFieldNames();
                List fieldTypes = ((UserDefinedType)cqlType).getFieldTypes();
                ConvertingCodec keyCodec = codecFactory.createConvertingCodec(DataTypes.TEXT, keyType, false);
                assert (fieldNames.size() == fieldTypes.size());
                for (int idx = 0; idx < fieldNames.size(); ++idx) {
                    CqlIdentifier fieldName = (CqlIdentifier)fieldNames.get(idx);
                    DataType fieldType = (DataType)fieldTypes.get(idx);
                    ConvertingCodec fieldCodec = codecFactory.createConvertingCodec(fieldType, valueType, false);
                    fieldCodecs.put((Object)fieldName, (Object)fieldCodec);
                }
                MapToUDTCodec codec = new MapToUDTCodec(externalJavaType.getRawType(), (TypeCodec<UdtValue>)udtCodec, keyCodec, fieldCodecs.build());
                return Optional.of(codec);
            }
        }
        return Optional.empty();
    }
}

