/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.map;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import java.util.LinkedHashMap;
import java.util.Map;

public class MapToMapCodec<EK, EV, IK, IV>
extends ConvertingCodec<Map<EK, EV>, Map<IK, IV>> {
    private final ConvertingCodec<EK, IK> keyCodec;
    private final ConvertingCodec<EV, IV> valueCodec;

    public MapToMapCodec(Class<Map<EK, EV>> javaType, TypeCodec<Map<IK, IV>> targetCodec, ConvertingCodec<EK, IK> keyCodec, ConvertingCodec<EV, IV> valueCodec) {
        super(targetCodec, javaType);
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
    }

    public Map<IK, IV> externalToInternal(Map<EK, EV> external) {
        if (external == null || external.isEmpty()) {
            return null;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<EK, EV> entry : external.entrySet()) {
            result.put(this.keyCodec.externalToInternal(entry.getKey()), this.valueCodec.externalToInternal(entry.getValue()));
        }
        return result;
    }

    public Map<EK, EV> internalToExternal(Map<IK, IV> internal) {
        if (internal == null || internal.isEmpty()) {
            return null;
        }
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        for (Map.Entry<IK, IV> entry : internal.entrySet()) {
            result.put(this.keyCodec.internalToExternal(entry.getKey()), this.valueCodec.internalToExternal(entry.getValue()));
        }
        return result;
    }
}

