/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.map;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapToUDTCodec<EK, EV>
extends ConvertingCodec<Map<EK, EV>, UdtValue> {
    private final Map<CqlIdentifier, ConvertingCodec<EV, Object>> fieldCodecs;
    private final ConvertingCodec<EK, String> keyCodec;
    private final UserDefinedType definition;

    public MapToUDTCodec(Class<Map<EK, EV>> javaType, TypeCodec<UdtValue> targetCodec, ConvertingCodec<EK, String> keyCodec, Map<CqlIdentifier, ConvertingCodec<EV, Object>> fieldCodecs) {
        super(targetCodec, javaType);
        this.fieldCodecs = fieldCodecs;
        this.keyCodec = keyCodec;
        this.definition = (UserDefinedType)targetCodec.getCqlType();
    }

    public UdtValue externalToInternal(Map<EK, EV> external) {
        if (external == null || external.isEmpty()) {
            return null;
        }
        int size = this.definition.getFieldNames().size();
        if (external.size() != size) {
            throw new IllegalArgumentException(String.format("Expecting %d fields, got %d", size, external.size()));
        }
        UdtValue value = this.definition.newValue();
        List fieldNames = this.definition.getFieldNames();
        for (CqlIdentifier udtFieldName : fieldNames) {
            Object mapKey = this.keyCodec.internalToExternal((Object)udtFieldName.asInternal());
            if (!external.containsKey(mapKey)) {
                throw new IllegalArgumentException(String.format("Field %s in UDT %s not found in input map", udtFieldName, this.definition.getName()));
            }
            ConvertingCodec<EV, Object> fieldCodec = this.fieldCodecs.get(udtFieldName);
            Object o = fieldCodec.externalToInternal(external.get(mapKey));
            value = (UdtValue)value.set(udtFieldName, o, fieldCodec.getInternalJavaType());
        }
        return value;
    }

    public Map<EK, EV> internalToExternal(UdtValue internal) {
        if (internal == null) {
            return null;
        }
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        for (CqlIdentifier name : this.definition.getFieldNames()) {
            Object key = this.keyCodec.internalToExternal((Object)name.asInternal());
            ConvertingCodec<EV, Object> eltCodec = this.fieldCodecs.get(name);
            Object o = internal.get(name, eltCodec.getInternalJavaType());
            Object value = eltCodec.internalToExternal(o);
            result.put(key, value);
        }
        return result;
    }
}

