/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.number;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

public class NumberToBooleanCodec<EXTERNAL extends Number>
extends ConvertingCodec<EXTERNAL, Boolean> {
    private final List<EXTERNAL> booleanNumbers;

    public NumberToBooleanCodec(Class<EXTERNAL> javaType, List<BigDecimal> booleanNumbers) {
        super((TypeCodec)TypeCodecs.BOOLEAN, javaType);
        this.booleanNumbers = booleanNumbers.stream().map(n -> CodecUtils.convertNumber((Number)n, (Class)javaType)).collect(Collectors.toList());
    }

    public Boolean externalToInternal(EXTERNAL value) {
        if (value == null) {
            return null;
        }
        int i = this.booleanNumbers.indexOf(value);
        if (i == -1) {
            throw new IllegalArgumentException(String.format("Invalid boolean number %s, accepted values are %s (true) and %s (false)", value, this.booleanNumbers.get(0), this.booleanNumbers.get(1)));
        }
        return i == 0;
    }

    public EXTERNAL internalToExternal(Boolean value) {
        if (value == null) {
            return null;
        }
        return (EXTERNAL)((Number)this.booleanNumbers.get(value != false ? 0 : 1));
    }
}

