/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.number;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;

public class NumberToInstantCodec<EXTERNAL extends Number>
extends ConvertingCodec<EXTERNAL, Instant> {
    private final TimeUnit timeUnit;
    private final ZonedDateTime epoch;

    public NumberToInstantCodec(Class<EXTERNAL> javaType, TimeUnit timeUnit, ZonedDateTime epoch) {
        super(TypeCodecs.TIMESTAMP, javaType);
        this.timeUnit = timeUnit;
        this.epoch = epoch;
    }

    public EXTERNAL internalToExternal(Instant value) {
        if (value == null) {
            return null;
        }
        long timestamp = CodecUtils.instantToNumber((Instant)value, (TimeUnit)this.timeUnit, (Instant)this.epoch.toInstant());
        Number n = CodecUtils.convertNumber((Number)timestamp, (Class)this.getJavaType().getRawType());
        return (EXTERNAL)n;
    }

    public Instant externalToInternal(EXTERNAL value) {
        if (value == null) {
            return null;
        }
        return CodecUtils.numberToInstant(value, (TimeUnit)this.timeUnit, (Instant)this.epoch.toInstant());
    }
}

