/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.number;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import io.netty.util.concurrent.FastThreadLocal;
import java.text.NumberFormat;

public class NumberToStringCodec<EXTERNAL extends Number>
extends ConvertingCodec<EXTERNAL, String> {
    private final FastThreadLocal<NumberFormat> numberFormat;

    public NumberToStringCodec(Class<EXTERNAL> javaType, FastThreadLocal<NumberFormat> numberFormat) {
        super(TypeCodecs.TEXT, javaType);
        this.numberFormat = numberFormat;
    }

    public EXTERNAL internalToExternal(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        throw new UnsupportedOperationException("This codec does not support converting from string to number");
    }

    public String externalToInternal(EXTERNAL value) {
        if (value == null) {
            return null;
        }
        return CodecUtils.formatNumber(value, (NumberFormat)((NumberFormat)this.numberFormat.get()));
    }
}

