/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.number;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.jdk.number.NumberToInstantCodec;
import java.time.Instant;
import java.util.UUID;

public class NumberToUUIDCodec<EXTERNAL extends Number>
extends ConvertingCodec<EXTERNAL, UUID> {
    private final NumberToInstantCodec<EXTERNAL> instantCodec;
    private final TimeUUIDGenerator generator;

    public NumberToUUIDCodec(TypeCodec<UUID> targetCodec, NumberToInstantCodec<EXTERNAL> instantCodec, TimeUUIDGenerator generator) {
        super(targetCodec, instantCodec.getJavaType().getRawType());
        this.instantCodec = instantCodec;
        this.generator = generator;
    }

    public EXTERNAL internalToExternal(UUID value) {
        if (value == null) {
            return null;
        }
        Instant instant = TimeUUIDGenerator.fromUUIDTimestamp((long)value.timestamp());
        return this.instantCodec.internalToExternal(instant);
    }

    public UUID externalToInternal(EXTERNAL value) {
        if (value == null) {
            return null;
        }
        Instant instant = this.instantCodec.externalToInternal(value);
        return this.generator.generate(instant);
    }
}

