/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.number;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.dsbulk.codecs.api.ConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.jdk.JdkCodecUtils;
import com.datastax.oss.dsbulk.codecs.jdk.number.NumberToBooleanCodec;
import com.datastax.oss.dsbulk.codecs.jdk.number.NumberToInstantCodec;
import com.datastax.oss.dsbulk.codecs.jdk.number.NumberToNumberCodec;
import com.datastax.oss.dsbulk.codecs.jdk.number.NumberToStringCodec;
import com.datastax.oss.dsbulk.codecs.jdk.number.NumberToUUIDCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.netty.util.concurrent.FastThreadLocal;
import java.text.NumberFormat;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class NumericConvertingCodecsProvider
implements ConvertingCodecProvider {
    @NonNull
    public Optional<ConvertingCodec<?, ?>> maybeProvide(@NonNull DataType cqlType, @NonNull GenericType<?> externalJavaType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        MutableCodecRegistry codecRegistry = codecFactory.getCodecRegistry();
        ConversionContext context = codecFactory.getContext();
        if (externalJavaType.isSubtypeOf(GenericType.of(Number.class))) {
            Class numberType = externalJavaType.getRawType();
            if (JdkCodecUtils.isNumeric(cqlType)) {
                TypeCodec typeCodec = codecRegistry.codecFor(cqlType);
                return Optional.of(new NumberToNumberCodec(numberType, typeCodec));
            }
            if (cqlType == DataTypes.TIMESTAMP) {
                return Optional.of(new NumberToInstantCodec(numberType, (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH")));
            }
            if (JdkCodecUtils.isUUID(cqlType)) {
                TypeCodec uuidCodec = codecRegistry.codecFor(cqlType);
                NumberToInstantCodec instantCodec = new NumberToInstantCodec(numberType, (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"));
                return Optional.of(new NumberToUUIDCodec((TypeCodec<UUID>)uuidCodec, instantCodec, (TimeUUIDGenerator)context.getAttribute("TIME_UUID_GENERATOR")));
            }
            if (cqlType == DataTypes.BOOLEAN) {
                return Optional.of(new NumberToBooleanCodec(numberType, (List)context.getAttribute("BOOLEAN_NUMBERS")));
            }
            if (cqlType == DataTypes.TEXT || cqlType == DataTypes.ASCII) {
                return Optional.of(new NumberToStringCodec(numberType, (FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT"))));
            }
        }
        return Optional.empty();
    }
}

