/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.temporal;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class DateToTemporalCodec<EXTERNAL extends Date, INTERNAL extends TemporalAccessor>
extends ConvertingCodec<EXTERNAL, INTERNAL> {
    private final ZoneId timeZone;

    public DateToTemporalCodec(Class<EXTERNAL> javaType, TypeCodec<INTERNAL> targetCodec, ZoneId timeZone) {
        super(targetCodec, javaType);
        this.timeZone = timeZone;
    }

    public EXTERNAL internalToExternal(INTERNAL value) {
        return (EXTERNAL)this.convert((TemporalAccessor)value, (GenericType<? extends Date>)((GenericType<Date>)this.getJavaType()));
    }

    public INTERNAL externalToInternal(EXTERNAL value) {
        return (INTERNAL)this.convert((Date)value, (GenericType<? extends TemporalAccessor>)((GenericType<TemporalAccessor>)this.internalCodec.getJavaType()));
    }

    private TemporalAccessor convert(Date value, GenericType<? extends TemporalAccessor> targetType) {
        if (value == null) {
            return null;
        }
        if (targetType.equals((Object)GenericType.LOCAL_DATE)) {
            if (value instanceof java.sql.Date) {
                return ((java.sql.Date)value).toLocalDate();
            }
            return value.toInstant().atZone(this.timeZone).toLocalDate();
        }
        if (targetType.equals((Object)GenericType.LOCAL_TIME)) {
            if (value instanceof Time) {
                return ((Time)value).toLocalTime();
            }
            return value.toInstant().atZone(this.timeZone).toLocalTime();
        }
        if (targetType.equals((Object)GenericType.of(LocalDateTime.class))) {
            if (value instanceof java.sql.Date) {
                return ((java.sql.Date)value).toLocalDate().atStartOfDay();
            }
            if (value instanceof Time) {
                return ((Time)value).toLocalTime().atDate(LocalDate.ofEpochDay(0L));
            }
            return value.toInstant().atZone(this.timeZone).toLocalDateTime();
        }
        if (targetType.equals((Object)GenericType.INSTANT)) {
            if (value instanceof java.sql.Date) {
                return ((java.sql.Date)value).toLocalDate().atStartOfDay(this.timeZone).toInstant();
            }
            if (value instanceof Time) {
                return ((Time)value).toLocalTime().atDate(LocalDate.ofEpochDay(0L)).atZone(this.timeZone).toInstant();
            }
            return value.toInstant();
        }
        if (targetType.equals((Object)GenericType.of(ZonedDateTime.class))) {
            if (value instanceof java.sql.Date) {
                return ((java.sql.Date)value).toLocalDate().atStartOfDay(this.timeZone);
            }
            if (value instanceof Time) {
                return ((Time)value).toLocalTime().atDate(LocalDate.ofEpochDay(0L)).atZone(this.timeZone);
            }
            return value.toInstant().atZone(this.timeZone);
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s of type %s to %s", value, value.getClass(), targetType));
    }

    private Date convert(TemporalAccessor value, GenericType<? extends Date> targetType) {
        if (value == null) {
            return null;
        }
        Class rawType = targetType.getRawType();
        if (rawType.equals(java.sql.Date.class)) {
            if (value instanceof LocalDate) {
                return java.sql.Date.valueOf((LocalDate)value);
            }
            if (value instanceof LocalDateTime) {
                return java.sql.Date.valueOf(((LocalDateTime)value).toLocalDate());
            }
            if (value instanceof Instant) {
                return java.sql.Date.valueOf(((Instant)value).atZone(this.timeZone).toLocalDate());
            }
            if (value instanceof ZonedDateTime) {
                return java.sql.Date.valueOf(((ZonedDateTime)value).withZoneSameInstant(this.timeZone).toLocalDate());
            }
        } else if (rawType.equals(Time.class)) {
            if (value instanceof LocalTime) {
                return Time.valueOf((LocalTime)value);
            }
            if (value instanceof LocalDateTime) {
                return Time.valueOf(((LocalDateTime)value).toLocalTime());
            }
            if (value instanceof Instant) {
                return Time.valueOf(((Instant)value).atZone(this.timeZone).toLocalTime());
            }
            if (value instanceof ZonedDateTime) {
                return Time.valueOf(((ZonedDateTime)value).withZoneSameInstant(this.timeZone).toLocalTime());
            }
        } else if (rawType.equals(Timestamp.class)) {
            if (value instanceof LocalDate) {
                return Timestamp.from(((LocalDate)value).atStartOfDay(this.timeZone).toInstant());
            }
            if (value instanceof LocalTime) {
                return Timestamp.from(((LocalTime)value).atDate(LocalDate.ofEpochDay(0L)).atZone(this.timeZone).toInstant());
            }
            if (value instanceof LocalDateTime) {
                return Timestamp.from(((LocalDateTime)value).atZone(this.timeZone).toInstant());
            }
            if (value instanceof Instant) {
                return Timestamp.from((Instant)value);
            }
            if (value instanceof ZonedDateTime) {
                return Timestamp.from(((ZonedDateTime)value).toInstant());
            }
        } else if (rawType.equals(Date.class)) {
            if (value instanceof LocalDate) {
                return Date.from(((LocalDate)value).atStartOfDay(this.timeZone).toInstant());
            }
            if (value instanceof LocalTime) {
                return Date.from(((LocalTime)value).atDate(LocalDate.ofEpochDay(0L)).atZone(this.timeZone).toInstant());
            }
            if (value instanceof LocalDateTime) {
                return Date.from(((LocalDateTime)value).atZone(this.timeZone).toInstant());
            }
            if (value instanceof Instant) {
                return Date.from((Instant)value);
            }
            if (value instanceof ZonedDateTime) {
                return Date.from(((ZonedDateTime)value).toInstant());
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s of type %s to %s", value, value.getClass(), rawType));
    }
}

