/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.temporal;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.jdk.temporal.DateToTemporalCodec;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;

public class DateToUUIDCodec<EXTERNAL extends Date>
extends ConvertingCodec<EXTERNAL, UUID> {
    private final DateToTemporalCodec<EXTERNAL, Instant> instantCodec;
    private final TimeUUIDGenerator generator;

    public DateToUUIDCodec(TypeCodec<UUID> targetCodec, DateToTemporalCodec<EXTERNAL, Instant> instantCodec, TimeUUIDGenerator generator) {
        super(targetCodec, instantCodec.getJavaType());
        this.instantCodec = instantCodec;
        this.generator = generator;
    }

    public EXTERNAL internalToExternal(UUID value) {
        if (value == null) {
            return null;
        }
        Instant instant = TimeUUIDGenerator.fromUUIDTimestamp((long)value.timestamp());
        return this.instantCodec.internalToExternal(instant);
    }

    public UUID externalToInternal(EXTERNAL value) {
        if (value == null) {
            return null;
        }
        Instant instant = this.instantCodec.externalToInternal(value);
        return this.generator.generate(instant);
    }
}

