/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.temporal;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.dsbulk.codecs.api.ConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.jdk.JdkCodecUtils;
import com.datastax.oss.dsbulk.codecs.jdk.temporal.DateToTemporalCodec;
import com.datastax.oss.dsbulk.codecs.jdk.temporal.DateToUUIDCodec;
import com.datastax.oss.dsbulk.codecs.jdk.temporal.TemporalToTemporalCodec;
import com.datastax.oss.dsbulk.codecs.jdk.temporal.TemporalToUUIDCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;

public class TemporalConvertingCodecsProvider
implements ConvertingCodecProvider {
    private static final GenericType<?> TEMPORAL_GENERIC_TYPE = GenericType.of(Temporal.class);
    private static final GenericType<Date> DATE_GENERIC_TYPE = GenericType.of(Date.class);

    @NonNull
    public Optional<ConvertingCodec<?, ?>> maybeProvide(@NonNull DataType cqlType, @NonNull GenericType<?> externalJavaType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        TypeCodec uuidCodec;
        ConversionContext context = codecFactory.getContext();
        if (externalJavaType.isSubtypeOf(TEMPORAL_GENERIC_TYPE) && JdkCodecUtils.isTemporal(cqlType)) {
            Class fromTemporalType = externalJavaType.getRawType();
            if (cqlType == DataTypes.DATE) {
                return Optional.of(new TemporalToTemporalCodec(fromTemporalType, TypeCodecs.DATE, (ZoneId)context.getAttribute("TIME_ZONE"), (ZonedDateTime)context.getAttribute("EPOCH")));
            }
            if (cqlType == DataTypes.TIME) {
                return Optional.of(new TemporalToTemporalCodec(fromTemporalType, TypeCodecs.TIME, (ZoneId)context.getAttribute("TIME_ZONE"), (ZonedDateTime)context.getAttribute("EPOCH")));
            }
            if (cqlType == DataTypes.TIMESTAMP) {
                return Optional.of(new TemporalToTemporalCodec(fromTemporalType, TypeCodecs.TIMESTAMP, (ZoneId)context.getAttribute("TIME_ZONE"), (ZonedDateTime)context.getAttribute("EPOCH")));
            }
        }
        if (externalJavaType.isSubtypeOf(TEMPORAL_GENERIC_TYPE) && JdkCodecUtils.isUUID(cqlType)) {
            uuidCodec = codecFactory.getCodecRegistry().codecFor(cqlType);
            TemporalToTemporalCodec instantCodec = (TemporalToTemporalCodec)codecFactory.createConvertingCodec(DataTypes.TIMESTAMP, externalJavaType, false);
            return Optional.of(new TemporalToUUIDCodec((TypeCodec<UUID>)uuidCodec, instantCodec, (TimeUUIDGenerator)context.getAttribute("TIME_UUID_GENERATOR")));
        }
        if (externalJavaType.isSubtypeOf(DATE_GENERIC_TYPE) && JdkCodecUtils.isTemporal(cqlType)) {
            if (cqlType == DataTypes.DATE) {
                return Optional.of(new DateToTemporalCodec(Date.class, TypeCodecs.DATE, (ZoneId)context.getAttribute("TIME_ZONE")));
            }
            if (cqlType == DataTypes.TIME) {
                return Optional.of(new DateToTemporalCodec(Date.class, TypeCodecs.TIME, (ZoneId)context.getAttribute("TIME_ZONE")));
            }
            if (cqlType == DataTypes.TIMESTAMP) {
                return Optional.of(new DateToTemporalCodec(Date.class, TypeCodecs.TIMESTAMP, (ZoneId)context.getAttribute("TIME_ZONE")));
            }
        }
        if (externalJavaType.isSubtypeOf(DATE_GENERIC_TYPE) && JdkCodecUtils.isUUID(cqlType)) {
            uuidCodec = codecFactory.getCodecRegistry().codecFor(cqlType);
            DateToTemporalCodec instantCodec = (DateToTemporalCodec)codecFactory.createConvertingCodec(DataTypes.TIMESTAMP, externalJavaType, false);
            return Optional.of(new DateToUUIDCodec((TypeCodec<UUID>)uuidCodec, instantCodec, (TimeUUIDGenerator)context.getAttribute("TIME_UUID_GENERATOR")));
        }
        return Optional.empty();
    }
}

