/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.temporal;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;

public class TemporalToTemporalCodec<EXTERNAL extends TemporalAccessor, INTERNAL extends TemporalAccessor>
extends ConvertingCodec<EXTERNAL, INTERNAL> {
    private final ZoneId timeZone;
    private final ZonedDateTime epoch;
    private final Class<EXTERNAL> rawJavaType;

    public TemporalToTemporalCodec(Class<EXTERNAL> javaType, TypeCodec<INTERNAL> targetCodec, ZoneId timeZone, ZonedDateTime epoch) {
        super(targetCodec, javaType);
        this.rawJavaType = javaType;
        this.timeZone = timeZone;
        this.epoch = epoch;
    }

    public Class<EXTERNAL> getRawJavaType() {
        return this.rawJavaType;
    }

    public EXTERNAL internalToExternal(INTERNAL value) {
        Class targetClass = this.getJavaType().getRawType();
        return (EXTERNAL)CodecUtils.convertTemporal(value, (Class)targetClass, (ZoneId)this.timeZone, (LocalDate)this.epoch.toLocalDate());
    }

    public INTERNAL externalToInternal(EXTERNAL value) {
        Class targetClass = this.internalCodec.getJavaType().getRawType();
        return (INTERNAL)CodecUtils.convertTemporal(value, (Class)targetClass, (ZoneId)this.timeZone, (LocalDate)this.epoch.toLocalDate());
    }
}

