/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.jdk.temporal;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.jdk.temporal.TemporalToTemporalCodec;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.UUID;

public class TemporalToUUIDCodec<EXTERNAL extends TemporalAccessor>
extends ConvertingCodec<EXTERNAL, UUID> {
    private final TemporalToTemporalCodec<EXTERNAL, Instant> instantCodec;
    private final TimeUUIDGenerator generator;

    public TemporalToUUIDCodec(TypeCodec<UUID> targetCodec, TemporalToTemporalCodec<EXTERNAL, Instant> instantCodec, TimeUUIDGenerator generator) {
        super(targetCodec, instantCodec.getRawJavaType());
        this.instantCodec = instantCodec;
        this.generator = generator;
    }

    public EXTERNAL internalToExternal(UUID value) {
        if (value == null) {
            return null;
        }
        Instant instant = TimeUUIDGenerator.fromUUIDTimestamp((long)value.timestamp());
        return this.instantCodec.internalToExternal(instant);
    }

    public UUID externalToInternal(EXTERNAL value) {
        if (value == null) {
            return null;
        }
        Instant instant = this.instantCodec.externalToInternal(value);
        return this.generator.generate(instant);
    }
}

