/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;

public abstract class JsonNodeConvertingCodec<T>
extends ConvertingCodec<JsonNode, T> {
    private final List<String> nullStrings;

    protected JsonNodeConvertingCodec(TypeCodec<T> targetCodec, List<String> nullStrings) {
        super(targetCodec, JsonNode.class);
        this.nullStrings = nullStrings;
    }

    protected boolean isNull(JsonNode node) {
        return node == null || node.isNull() || node.isMissingNode() || node.isValueNode() && this.nullStrings.contains(node.asText());
    }

    protected boolean isNullOrEmpty(JsonNode node) {
        return this.isNull(node) || node.isValueNode() && node.asText().isEmpty();
    }
}

