/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.CqlVectorType;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.CodecNotFoundException;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.type.codec.CqlVectorCodec;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.codecs.api.ConversionContext;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecFactory;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodecProvider;
import com.datastax.oss.dsbulk.codecs.api.format.binary.BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.format.geo.GeoFormat;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.api.util.TimeUUIDGenerator;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToBigDecimalCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToBigIntegerCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToBlobCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToBooleanCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToByteCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToDoubleCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToDurationCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToFloatCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToInetAddressCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToInstantCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToIntegerCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToListCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToLocalDateCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToLocalTimeCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToLongCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToMapCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToSetCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToShortCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToStringCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToTupleCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToUDTCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToUUIDCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToUnknownTypeCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToVectorCodec;
import com.datastax.oss.dsbulk.codecs.text.json.dse.JsonNodeToDateRangeCodec;
import com.datastax.oss.dsbulk.codecs.text.json.dse.JsonNodeToLineStringCodec;
import com.datastax.oss.dsbulk.codecs.text.json.dse.JsonNodeToPointCodec;
import com.datastax.oss.dsbulk.codecs.text.json.dse.JsonNodeToPolygonCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.netty.util.concurrent.FastThreadLocal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonNodeConvertingCodecProvider
implements ConvertingCodecProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonNodeConvertingCodecProvider.class);
    private static final String LINE_STRING_CLASS_NAME = "org.apache.cassandra.db.marshal.LineStringType";
    private static final String POINT_CLASS_NAME = "org.apache.cassandra.db.marshal.PointType";
    private static final String POLYGON_CLASS_NAME = "org.apache.cassandra.db.marshal.PolygonType";
    private static final String DATE_RANGE_CLASS_NAME = "org.apache.cassandra.db.marshal.DateRangeType";

    @NonNull
    public Optional<ConvertingCodec<?, ?>> maybeProvide(@NonNull DataType cqlType, @NonNull GenericType<?> externalJavaType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        if (!externalJavaType.equals(JsonCodecUtils.JSON_NODE_TYPE)) {
            return Optional.empty();
        }
        ConvertingCodec<JsonNode, ?> codec = this.createJsonNodeConvertingCodec(cqlType, codecFactory, rootCodec);
        return Optional.ofNullable(codec);
    }

    @Nullable
    private ConvertingCodec<JsonNode, ?> createJsonNodeConvertingCodec(@NonNull DataType cqlType, @NonNull ConvertingCodecFactory codecFactory, boolean rootCodec) {
        MutableCodecRegistry codecRegistry = codecFactory.getCodecRegistry();
        ConversionContext context = codecFactory.getContext();
        ImmutableList nullStrings = rootCodec ? (List)context.getAttribute("NULL_STRINGS") : ImmutableList.of();
        int cqlTypeCode = cqlType.getProtocolCode();
        switch (cqlTypeCode) {
            case 1: 
            case 13: {
                TypeCodec typeCodec = codecRegistry.codecFor(cqlType);
                return new JsonNodeToStringCodec((TypeCodec<String>)typeCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 4: {
                return new JsonNodeToBooleanCodec((Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List<String>)nullStrings);
            }
            case 20: {
                return new JsonNodeToByteCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 19: {
                return new JsonNodeToShortCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 9: {
                return new JsonNodeToIntegerCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 2: {
                return new JsonNodeToLongCodec(TypeCodecs.BIGINT, (FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map<String, Boolean>)((Map)context.getAttribute("BOOLEAN_INPUT_WORDS")), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 5: {
                return new JsonNodeToLongCodec(TypeCodecs.COUNTER, (FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map<String, Boolean>)((Map)context.getAttribute("BOOLEAN_INPUT_WORDS")), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 8: {
                return new JsonNodeToFloatCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 7: {
                return new JsonNodeToDoubleCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 14: {
                return new JsonNodeToBigIntegerCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 6: {
                return new JsonNodeToBigDecimalCodec((FastThreadLocal<NumberFormat>)((FastThreadLocal)context.getAttribute("NUMBER_FORMAT")), (OverflowStrategy)context.getAttribute("OVERFLOW_STRATEGY"), (RoundingMode)((Object)context.getAttribute("ROUNDING_MODE")), (TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (TimeUnit)((Object)context.getAttribute("TIME_UNIT")), (ZonedDateTime)context.getAttribute("EPOCH"), (Map)context.getAttribute("BOOLEAN_INPUT_WORDS"), (List)context.getAttribute("BOOLEAN_NUMBERS"), (List<String>)nullStrings);
            }
            case 17: {
                return new JsonNodeToLocalDateCodec((TemporalFormat)context.getAttribute("LOCAL_DATE_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (List<String>)nullStrings);
            }
            case 18: {
                return new JsonNodeToLocalTimeCodec((TemporalFormat)context.getAttribute("LOCAL_TIME_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (List<String>)nullStrings);
            }
            case 11: {
                return new JsonNodeToInstantCodec((TemporalFormat)context.getAttribute("TIMESTAMP_FORMAT"), (ZoneId)context.getAttribute("TIME_ZONE"), (ZonedDateTime)context.getAttribute("EPOCH"), (List<String>)nullStrings);
            }
            case 16: {
                return new JsonNodeToInetAddressCodec((List<String>)nullStrings);
            }
            case 12: {
                ConvertingCodec instantCodec = codecFactory.createConvertingCodec(DataTypes.TIMESTAMP, GenericType.STRING, false);
                return new JsonNodeToUUIDCodec((TypeCodec<UUID>)TypeCodecs.UUID, (ConvertingCodec<String, Instant>)instantCodec, (TimeUUIDGenerator)context.getAttribute("TIME_UUID_GENERATOR"), (List<String>)nullStrings);
            }
            case 15: {
                ConvertingCodec instantCodec = codecFactory.createConvertingCodec(DataTypes.TIMESTAMP, GenericType.STRING, false);
                return new JsonNodeToUUIDCodec((TypeCodec<UUID>)TypeCodecs.TIMEUUID, (ConvertingCodec<String, Instant>)instantCodec, (TimeUUIDGenerator)context.getAttribute("TIME_UUID_GENERATOR"), (List<String>)nullStrings);
            }
            case 3: {
                return new JsonNodeToBlobCodec((BinaryFormat)context.getAttribute("BINARY_FORMAT"), (List<String>)nullStrings);
            }
            case 21: {
                return new JsonNodeToDurationCodec((List<String>)nullStrings);
            }
            case 32: {
                DataType elementType = ((ListType)cqlType).getElementType();
                TypeCodec collectionCodec = codecRegistry.codecFor(cqlType);
                ConvertingCodec<JsonNode, ?> eltCodec = this.createJsonNodeConvertingCodec(elementType, codecFactory, false);
                return new JsonNodeToListCodec(collectionCodec, eltCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 34: {
                DataType elementType = ((SetType)cqlType).getElementType();
                TypeCodec collectionCodec = codecRegistry.codecFor(cqlType);
                ConvertingCodec<JsonNode, ?> eltCodec = this.createJsonNodeConvertingCodec(elementType, codecFactory, false);
                return new JsonNodeToSetCodec(collectionCodec, eltCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 33: {
                DataType keyType = ((MapType)cqlType).getKeyType();
                DataType valueType = ((MapType)cqlType).getValueType();
                TypeCodec mapCodec = codecRegistry.codecFor(cqlType);
                ConvertingCodec keyCodec = codecFactory.createConvertingCodec(keyType, GenericType.STRING, false);
                ConvertingCodec valueCodec = codecFactory.createConvertingCodec(valueType, JsonCodecUtils.JSON_NODE_TYPE, false);
                return new JsonNodeToMapCodec(mapCodec, keyCodec, valueCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
            }
            case 49: {
                TypeCodec tupleCodec = codecRegistry.codecFor(cqlType);
                ImmutableList.Builder eltCodecs = new ImmutableList.Builder();
                for (DataType eltType : ((TupleType)cqlType).getComponentTypes()) {
                    ConvertingCodec eltCodec = codecFactory.createConvertingCodec(eltType, JsonCodecUtils.JSON_NODE_TYPE, false);
                    eltCodecs.add((Object)Objects.requireNonNull(eltCodec));
                }
                return new JsonNodeToTupleCodec((TypeCodec<TupleValue>)tupleCodec, (List<ConvertingCodec<JsonNode, Object>>)eltCodecs.build(), (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings, (Boolean)context.getAttribute("ALLOW_EXTRA_FIELDS"), (Boolean)context.getAttribute("ALLOW_MISSING_FIELDS"));
            }
            case 48: {
                TypeCodec udtCodec = codecRegistry.codecFor(cqlType);
                ImmutableMap.Builder fieldCodecs = new ImmutableMap.Builder();
                List fieldNames = ((UserDefinedType)cqlType).getFieldNames();
                List fieldTypes = ((UserDefinedType)cqlType).getFieldTypes();
                assert (fieldNames.size() == fieldTypes.size());
                for (int idx = 0; idx < fieldNames.size(); ++idx) {
                    CqlIdentifier fieldName = (CqlIdentifier)fieldNames.get(idx);
                    DataType fieldType = (DataType)fieldTypes.get(idx);
                    ConvertingCodec fieldCodec = codecFactory.createConvertingCodec(fieldType, JsonCodecUtils.JSON_NODE_TYPE, false);
                    fieldCodecs.put((Object)fieldName, (Object)Objects.requireNonNull(fieldCodec));
                }
                return new JsonNodeToUDTCodec((TypeCodec<UdtValue>)udtCodec, (Map<CqlIdentifier, ConvertingCodec<JsonNode, Object>>)fieldCodecs.build(), (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings, (Boolean)context.getAttribute("ALLOW_EXTRA_FIELDS"), (Boolean)context.getAttribute("ALLOW_MISSING_FIELDS"));
            }
            case 0: {
                CustomType customType = (CustomType)cqlType;
                switch (customType.getClassName()) {
                    case "org.apache.cassandra.db.marshal.PointType": {
                        return new JsonNodeToPointCodec((ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (GeoFormat)context.getAttribute("GEO_FORMAT"), (List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.LineStringType": {
                        return new JsonNodeToLineStringCodec((ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (GeoFormat)context.getAttribute("GEO_FORMAT"), (List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.PolygonType": {
                        return new JsonNodeToPolygonCodec((ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (GeoFormat)context.getAttribute("GEO_FORMAT"), (List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.DateRangeType": {
                        return new JsonNodeToDateRangeCodec((List<String>)nullStrings);
                    }
                    case "org.apache.cassandra.db.marshal.VectorType": {
                        CqlVectorType cqlVectorType = (CqlVectorType)cqlType;
                        ConvertingCodec<JsonNode, ?> jsonCodec = this.createJsonNodeConvertingCodec(cqlVectorType.getSubtype(), codecFactory, false);
                        ConvertingCodec standardCodec = codecFactory.createConvertingCodec(cqlVectorType.getSubtype(), jsonCodec.getInternalJavaType(), false);
                        return new JsonNodeToVectorCodec(new CqlVectorCodec(cqlVectorType, (TypeCodec)standardCodec), jsonCodec, (ObjectMapper)context.getAttribute("OBJECT_MAPPER"), (List<String>)nullStrings);
                    }
                }
            }
        }
        try {
            TypeCodec innerCodec = codecRegistry.codecFor(cqlType);
            LOGGER.warn(String.format("CQL type %s is not officially supported by this version of DSBulk; JSON literals will be parsed and formatted using registered codec %s", cqlType, innerCodec.getClass().getSimpleName()));
            return new JsonNodeToUnknownTypeCodec(innerCodec, (List<String>)nullStrings);
        }
        catch (CodecNotFoundException codecNotFoundException) {
            return null;
        }
    }
}

