/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.format.binary.BinaryFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;

public class JsonNodeToBlobCodec
extends JsonNodeConvertingCodec<ByteBuffer> {
    private final BinaryFormat binaryFormat;

    public JsonNodeToBlobCodec(BinaryFormat binaryFormat, List<String> nullStrings) {
        super(TypeCodecs.BLOB, nullStrings);
        this.binaryFormat = binaryFormat;
    }

    public ByteBuffer externalToInternal(JsonNode node) {
        if (this.isNull(node)) {
            return null;
        }
        if (node.isBinary()) {
            try {
                return ByteBuffer.wrap(node.binaryValue());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String s = node.asText();
        return CodecUtils.parseByteBuffer((String)s);
    }

    public JsonNode internalToExternal(ByteBuffer value) {
        return JsonCodecUtils.JSON_NODE_FACTORY.textNode(this.binaryFormat.format(value));
    }
}

