/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Map;

public class JsonNodeToBooleanCodec
extends JsonNodeConvertingCodec<Boolean> {
    private final Map<String, Boolean> inputs;

    public JsonNodeToBooleanCodec(Map<String, Boolean> inputs, List<String> nullStrings) {
        super(TypeCodecs.BOOLEAN, nullStrings);
        this.inputs = inputs;
    }

    public Boolean externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        String s = node.asText();
        Boolean b = this.inputs.get(s.toLowerCase());
        if (b == null) {
            throw new IllegalArgumentException("Invalid boolean value: " + s);
        }
        return b;
    }

    public JsonNode internalToExternal(Boolean value) {
        return value == null ? null : JsonCodecUtils.JSON_NODE_FACTORY.booleanNode(value.booleanValue());
    }
}

