/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToNumberCodec;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.util.concurrent.FastThreadLocal;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class JsonNodeToByteCodec
extends JsonNodeToNumberCodec<Byte> {
    public JsonNodeToByteCodec(FastThreadLocal<NumberFormat> numberFormat, OverflowStrategy overflowStrategy, RoundingMode roundingMode, TemporalFormat temporalFormat, ZoneId timeZone, TimeUnit timeUnit, ZonedDateTime epoch, Map<String, Boolean> booleanStrings, List<BigDecimal> booleanNumbers, List<String> nullStrings) {
        super(TypeCodecs.TINYINT, numberFormat, overflowStrategy, roundingMode, temporalFormat, timeZone, timeUnit, epoch, booleanStrings, booleanNumbers.stream().map(BigDecimal::byteValueExact).collect(Collectors.toList()), nullStrings);
    }

    public Byte externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        Number number = node.isNumber() ? (Number)node.numberValue() : (Number)this.parseNumber(node);
        if (number == null) {
            return null;
        }
        return this.narrowNumber(number, Byte.class);
    }

    public JsonNode internalToExternal(Byte value) {
        return value == null ? null : JsonCodecUtils.JSON_NODE_FACTORY.numberNode(value);
    }
}

