/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;

public abstract class JsonNodeToCollectionCodec<E, C extends Collection<E>>
extends JsonNodeConvertingCodec<C> {
    private final ConvertingCodec<JsonNode, E> eltCodec;
    private final Supplier<C> collectionSupplier;
    private final ObjectMapper objectMapper;
    private final C emptyCollection;

    JsonNodeToCollectionCodec(TypeCodec<C> collectionCodec, ConvertingCodec<JsonNode, E> eltCodec, ObjectMapper objectMapper, Supplier<C> collectionSupplier, List<String> nullStrings, C emptyCollection) {
        super(collectionCodec, nullStrings);
        this.eltCodec = eltCodec;
        this.objectMapper = objectMapper;
        this.collectionSupplier = collectionSupplier;
        this.emptyCollection = emptyCollection;
    }

    public C externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        if (!node.isArray()) {
            throw new IllegalArgumentException("Expecting ARRAY node, got " + node.getNodeType());
        }
        if (node.size() == 0) {
            return this.emptyCollection;
        }
        Iterator elements = node.elements();
        Collection collection = (Collection)this.collectionSupplier.get();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            collection.add(this.eltCodec.externalToInternal((Object)element));
        }
        return (C)collection;
    }

    public JsonNode internalToExternal(C value) {
        if (value == null) {
            return null;
        }
        ArrayNode root = this.objectMapper.createArrayNode();
        for (Object element : value) {
            root.add((JsonNode)this.eltCodec.internalToExternal(element));
        }
        return root;
    }
}

