/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.text.json.JsonCodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.InetAddress;
import java.util.List;

public class JsonNodeToInetAddressCodec
extends JsonNodeConvertingCodec<InetAddress> {
    public JsonNodeToInetAddressCodec(List<String> nullStrings) {
        super(TypeCodecs.INET, nullStrings);
    }

    public InetAddress externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        String s = node.asText();
        if (s.isEmpty()) {
            throw new IllegalArgumentException("Cannot create inet address from empty string");
        }
        try {
            return InetAddress.getByName(s);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse inet address: " + s);
        }
    }

    public JsonNode internalToExternal(InetAddress value) {
        return value == null ? null : JsonCodecUtils.JSON_NODE_FACTORY.textNode(value.getHostAddress());
    }
}

