/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToTemporalCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public class JsonNodeToInstantCodec
extends JsonNodeToTemporalCodec<Instant> {
    private final ZoneId timeZone;
    private final ZonedDateTime epoch;

    public JsonNodeToInstantCodec(TemporalFormat temporalFormat, ZoneId timeZone, ZonedDateTime epoch, List<String> nullStrings) {
        super(TypeCodecs.TIMESTAMP, temporalFormat, nullStrings);
        this.timeZone = timeZone;
        this.epoch = epoch;
    }

    public Instant externalToInternal(JsonNode node) {
        TemporalAccessor temporal = this.parseTemporalAccessor(node);
        if (temporal == null) {
            return null;
        }
        return CodecUtils.toInstant((TemporalAccessor)temporal, (ZoneId)this.timeZone, (LocalDate)this.epoch.toLocalDate());
    }
}

