/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeToTemporalCodec;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.List;

public class JsonNodeToLocalDateCodec
extends JsonNodeToTemporalCodec<LocalDate> {
    private final ZoneId timeZone;

    public JsonNodeToLocalDateCodec(TemporalFormat parser, ZoneId timeZone, List<String> nullStrings) {
        super(TypeCodecs.DATE, parser, nullStrings);
        this.timeZone = timeZone;
    }

    public LocalDate externalToInternal(JsonNode node) {
        TemporalAccessor temporal = this.parseTemporalAccessor(node);
        if (temporal == null) {
            return null;
        }
        return CodecUtils.toLocalDate((TemporalAccessor)temporal, (ZoneId)this.timeZone);
    }
}

