/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.dsbulk.codecs.api.ConvertingCodec;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonNodeToMapCodec<K, V>
extends JsonNodeConvertingCodec<Map<K, V>> {
    private final ConvertingCodec<String, K> keyCodec;
    private final ConvertingCodec<JsonNode, V> valueCodec;
    private final ObjectMapper objectMapper;
    private final Map<K, V> emptyMap;

    public JsonNodeToMapCodec(TypeCodec<Map<K, V>> collectionCodec, ConvertingCodec<String, K> keyCodec, ConvertingCodec<JsonNode, V> valueCodec, ObjectMapper objectMapper, List<String> nullStrings) {
        super(collectionCodec, nullStrings);
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
        this.objectMapper = objectMapper;
        this.emptyMap = ImmutableMap.of();
    }

    public Map<K, V> externalToInternal(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        if (!node.isObject()) {
            throw new IllegalArgumentException("Expecting OBJECT node, got " + node.getNodeType());
        }
        if (node.size() == 0) {
            return this.emptyMap;
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(node.size());
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            map.put(this.keyCodec.externalToInternal((Object)((String)entry.getKey())), this.valueCodec.externalToInternal((Object)((JsonNode)entry.getValue())));
        }
        return map;
    }

    public JsonNode internalToExternal(Map<K, V> map) {
        if (map == null) {
            return null;
        }
        ObjectNode root = this.objectMapper.createObjectNode();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            String key = (String)this.keyCodec.internalToExternal(entry.getKey());
            JsonNode value = (JsonNode)this.valueCodec.internalToExternal(entry.getValue());
            root.set(key, value);
        }
        return root;
    }
}

