/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.dsbulk.codecs.text.json;

import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.dsbulk.codecs.api.format.temporal.TemporalFormat;
import com.datastax.oss.dsbulk.codecs.api.util.CodecUtils;
import com.datastax.oss.dsbulk.codecs.api.util.OverflowStrategy;
import com.datastax.oss.dsbulk.codecs.text.json.JsonNodeConvertingCodec;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.util.concurrent.FastThreadLocal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

abstract class JsonNodeToNumberCodec<N extends Number>
extends JsonNodeConvertingCodec<N> {
    private final FastThreadLocal<NumberFormat> numberFormat;
    private final OverflowStrategy overflowStrategy;
    private final RoundingMode roundingMode;
    private final TemporalFormat temporalFormat;
    private final ZoneId timeZone;
    private final TimeUnit timeUnit;
    private final ZonedDateTime epoch;
    private final Map<String, Boolean> booleanStrings;
    private final List<N> booleanNumbers;

    JsonNodeToNumberCodec(TypeCodec<N> targetCodec, FastThreadLocal<NumberFormat> numberFormat, OverflowStrategy overflowStrategy, RoundingMode roundingMode, TemporalFormat temporalFormat, ZoneId timeZone, TimeUnit timeUnit, ZonedDateTime epoch, Map<String, Boolean> booleanStrings, List<N> booleanNumbers, List<String> nullStrings) {
        super(targetCodec, nullStrings);
        this.numberFormat = numberFormat;
        this.overflowStrategy = overflowStrategy;
        this.roundingMode = roundingMode;
        this.temporalFormat = temporalFormat;
        this.timeZone = timeZone;
        this.timeUnit = timeUnit;
        this.epoch = epoch;
        this.booleanStrings = booleanStrings;
        this.booleanNumbers = booleanNumbers;
    }

    Number parseNumber(JsonNode node) {
        if (this.isNullOrEmpty(node)) {
            return null;
        }
        return CodecUtils.parseNumber((String)node.asText(), (NumberFormat)((NumberFormat)this.numberFormat.get()), (TemporalFormat)this.temporalFormat, (ZoneId)this.timeZone, (TimeUnit)this.timeUnit, (ZonedDateTime)this.epoch, this.booleanStrings, this.booleanNumbers);
    }

    N narrowNumber(Number number, Class<? extends N> targetClass) {
        return (N)CodecUtils.narrowNumber((Number)number, targetClass, (OverflowStrategy)this.overflowStrategy, (RoundingMode)this.roundingMode);
    }
}

